/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client;

import com.mrbysco.structurecompass.client.screen.CompassScreen;
import com.mrbysco.structurecompass.init.StructureItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)StructureItems.STRUCTURE_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ItemPropertyFunction(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float m_141951_(ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingBaseIn, int p_174679_) {
                double d0;
                StructurePos globalPos;
                LivingEntity entity;
                if (livingBaseIn == null && !stack.m_41794_()) {
                    return 0.0f;
                }
                boolean livingExists = livingBaseIn != null;
                Object object = entity = livingExists ? livingBaseIn : stack.m_41795_();
                if (clientLevel == null && entity.f_19853_ instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.f_19853_;
                }
                if ((globalPos = this.getStructurePos(stack)) != null && clientLevel.m_46472_().m_135782_().equals((Object)globalPos.dimensionLocation())) {
                    double d1 = livingExists ? (double)entity.m_146908_() : this.getFrameRotation((ItemFrame)entity);
                    d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getSpawnToAngle((Entity)entity, globalPos.pos()) / 6.2831854820251465;
                    d0 = 0.5 - (d1 - 0.25 - d2);
                } else {
                    d0 = Math.random();
                }
                if (livingExists) {
                    d0 = this.wobble(clientLevel, d0);
                }
                return Mth.m_14091_((float)((float)d0), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientLevel worldIn, double p_185093_2_) {
                if (worldIn.m_46467_() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.m_46467_();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.m_6350_();
                int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + itemFrame.m_31823_() * 45 + i));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getSpawnToAngle(Entity entityIn, @NotNull BlockPos pos) {
                return Math.atan2((double)pos.m_123343_() - entityIn.m_20189_(), (double)pos.m_123341_() - entityIn.m_20185_());
            }

            public StructurePos getStructurePos(ItemStack stack) {
                CompoundTag tag;
                if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("structurecompass:structureFound") && tag.m_128471_("structurecompass:structureFound") && tag.m_128441_("structurecompass:structurePosition") && tag.m_128441_("structurecompass:structureDimension")) {
                    BlockPos structurePos = BlockPos.m_122022_((long)tag.m_128454_("structurecompass:structurePosition"));
                    ResourceLocation dimensionLoc = ResourceLocation.m_135820_((String)tag.m_128461_("structurecompass:structureDimension"));
                    return new StructurePos(structurePos, dimensionLoc);
                }
                return null;
            }
        });
    }

    public static void openStructureScreen(InteractionHand hand, ItemStack stack, List<ResourceLocation> allStructures) {
        Minecraft.m_91087_().m_91152_((Screen)new CompassScreen(hand, stack, allStructures));
    }

    public record StructurePos(BlockPos pos, ResourceLocation dimensionLocation) {
    }
}

